/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.Mekanism;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class ChemicalChemicalToChemicalRecipeSerializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory;

    protected ChemicalChemicalToChemicalRecipeSerializer(IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory) {
        this.factory = factory;
    }

    protected abstract ChemicalIngredientDeserializer<CHEMICAL, STACK, INGREDIENT> getDeserializer();

    protected abstract STACK fromJson(@Nonnull JsonObject var1, @Nonnull String var2);

    protected abstract STACK fromBuffer(@Nonnull FriendlyByteBuf var1);

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray leftIngredients = GsonHelper.m_13885_((JsonObject)json, (String)"leftInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"leftInput") : GsonHelper.m_13930_((JsonObject)json, (String)"leftInput");
        INGREDIENT leftInput = this.getDeserializer().deserialize((JsonElement)leftIngredients);
        JsonArray rightIngredients = GsonHelper.m_13885_((JsonObject)json, (String)"rightInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"rightInput") : GsonHelper.m_13930_((JsonObject)json, (String)"rightInput");
        INGREDIENT rightInput = this.getDeserializer().deserialize((JsonElement)rightIngredients);
        STACK output = this.fromJson(json, "output");
        if (((ChemicalStack)output).isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, leftInput, rightInput, output);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            INGREDIENT leftInput = this.getDeserializer().read(buffer);
            INGREDIENT rightInput = this.getDeserializer().read(buffer);
            STACK output = this.fromBuffer(buffer);
            return this.factory.create(recipeId, leftInput, rightInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading chemical chemical to chemical recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        try {
            ((ChemicalChemicalToChemicalRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing chemical chemical to chemical recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>> {
        public RECIPE create(ResourceLocation var1, INGREDIENT var2, INGREDIENT var3, STACK var4);
    }
}

